#pragma once

#include "config.h"

#include <library/cpp/http/simple/http_client.h>

namespace NPassport::NTvm {
    class TOAuthClient {
    public:
        TOAuthClient(const TConfig::TOAuth& cfg);
        TString GetToken(const TConfig::TOAuth& cfg);

    private:
        static TString ParseResponse(const TStringBuf body);
        static TKeepAliveHttpClient CreateClient(const TConfig::TOAuth& cfg);

    private:
        TKeepAliveHttpClient Handle_;
    };
}
