#include "public_keys_builder.h"

#include <passport/infra/libs/cpp/utils/string/coder.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <library/cpp/tvmauth/src/parser.h>

namespace NPassport::NTvm {
    void TPublicKeysBuilder::AddBbKey(NTvmAuth::NRw::TKeyId id,
                                      time_t createdTime,
                                      tvm_keys::BbEnvType env,
                                      const TString& body,
                                      tvm_keys::KeyType type) {
        tvm_keys::BbKey* key = Proto_.add_bb();
        Fill(*key->mutable_gen(), id, createdTime, body, type);
        key->set_env(env);
    }

    void TPublicKeysBuilder::AddTvmKey(NTvmAuth::NRw::TKeyId id,
                                       time_t createdTime,
                                       const TString& body,
                                       tvm_keys::KeyType type) {
        tvm_keys::TvmKey* key = Proto_.add_tvm();
        Fill(*key->mutable_gen(), id, createdTime, body, type);
    }

    TString TPublicKeysBuilder::SerializeV1() const {
        return NUtils::CreateStr(
            "1",
            NTvmAuth::TParserTvmKeys::DELIM,
            NUtils::Bin2base64url(Proto_.SerializeAsString()));
    }

    void TPublicKeysBuilder::Fill(tvm_keys::General& gen,
                                  NTvmAuth::NRw::TKeyId id,
                                  time_t createdTime,
                                  const TString& body,
                                  tvm_keys::KeyType type) {
        gen.set_id(id);
        gen.set_createdtime(createdTime);
        gen.set_body(body.data(), body.size());
        gen.set_type(type);
    }

}
