#pragma once

#include <library/cpp/tvmauth/src/protos/tvm_keys.pb.h>
#include <library/cpp/tvmauth/src/rw/keys.h>

namespace NPassport::NTvm {
    class TPublicKeysBuilder {
    public:
        void AddBbKey(NTvmAuth::NRw::TKeyId id,
                      time_t createdTime,
                      tvm_keys::BbEnvType env,
                      const TString& body,
                      tvm_keys::KeyType type = tvm_keys::RabinWilliams);
        void AddTvmKey(NTvmAuth::NRw::TKeyId id,
                       time_t createdTime,
                       const TString& body,
                       tvm_keys::KeyType type = tvm_keys::RabinWilliams);

        TString SerializeV1() const;

    private:
        static void Fill(tvm_keys::General& gen,
                         NTvmAuth::NRw::TKeyId id,
                         time_t createdTime,
                         const TString& body,
                         tvm_keys::KeyType type);
        tvm_keys::Keys Proto_;
    };

}
