#pragma once

#include "config.h"

#include <passport/infra/libs/cpp/dbpool/db_pool_ctx.h>
#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/generic/string.h>

#include <memory>
#include <shared_mutex>
#include <vector>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NTvm::NPregen {
    class TFacade;
}

namespace NPassport::NTvm {
    class TAbcFetcher;
    class TDbFetcher;
    class TNotifyLog;
    class TRetrySettingsHelper;
    class TStaffFetcher;
    class TTvmCertClient;

    class TRuntimeContext {
    public:
        class TDb {
        public:
            NDbPool::TDbPool* Tvm() const {
                return Tvm_.get();
            }

            std::shared_ptr<NDbPool::TDbPoolCtx> DbPoolCtx() const {
                return Ctx_;
            }

            void AddUnistat(NUnistat::TBuilder& builder) const;

        private:
            mutable std::shared_ptr<NDbPool::TDbPoolCtx> Ctx_;
            std::shared_ptr<NDbPool::TDbPool> Tvm_;
            friend class TRuntimeContext;
        };

    public:
        TRuntimeContext(const NXml::TConfig& config, const TString& path);
        ~TRuntimeContext();

        void AddUnistat(NUnistat::TBuilder& builder) const;

        ui32 HostId() const;

        const TDbFetcher& DbFetcher() const {
            return *DbFetcher_;
        }

        const TDb& Db() const {
            return Db_;
        }

        const TStaffFetcher& StaffFetcher() const {
            return *StaffFetcher_;
        }

        const TTvmCertClient& TvmCertClient() const {
            return *TvmCertClient_;
        }

        const TAbcFetcher& AbcFetcher() const {
            return *AbcFetcher_;
        }

        bool IsForceDown() const;
        bool IsDbOk(TString& str) const;

        bool IsVerifierSshClientIdAllowed(ui32 clId) const;
        bool IsCheckSecretClientIdAllowed(ui32 clId) const;

        const TConfig& Config() const {
            return Config_;
        }

        const NPregen::TFacade& Pregeneration() const {
            return *Pregeneration_;
        }

        TString GetOAuthToken() const;

        TNotifyLog& NotifyLog() const {
            return *NotifyLog_;
        }

        const TRetrySettingsHelper& GetRetrySettingsHelper() const;

    private:
        class TAuthorizationHolder {
        public:
            TString Get(const TConfig::TOAuth& cfg) const;

        private:
            mutable std::shared_timed_mutex Mutex_;
            mutable TString Header_;
        };

    private:
        void InitDb(const NXml::TConfig& config, const TString& path);

        TConfig Config_; // used in ~pregen::Facade()
        TAuthorizationHolder Auth_;

        TDb Db_;
        std::unique_ptr<TDbFetcher> DbFetcher_;
        std::unique_ptr<TStaffFetcher> StaffFetcher_;
        std::unique_ptr<TAbcFetcher> AbcFetcher_;
        std::unique_ptr<NPregen::TFacade> Pregeneration_;
        std::unique_ptr<TNotifyLog> NotifyLog_;
        std::unique_ptr<TRetrySettingsHelper> RetrySettings_;
        std::unique_ptr<TTvmCertClient> TvmCertClient_;

        mutable NUnistat::TSignalDiff<> UnistatOauthErrors_ = {"internal_error.oauth.query"};
    };

}
