#pragma once

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>
#include <passport/infra/libs/cpp/utils/crypto/sshkey.h>

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <memory>
#include <unordered_map>
#include <vector>

class TKeepAliveHttpClient;

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NTvm {
    class TRuntimeContext;

    class TStaffFetcher {
    public:
        TStaffFetcher(const TRuntimeContext& runtime);
        virtual ~TStaffFetcher();

        void AddUnistat(NUnistat::TBuilder& builder) const;

        ui64 LoginToUid(const TString& login) const;
        TString UidToLogin(const ui64 uid) const;

        struct TCheckResult {
            TString Err;
            TString Fingerprint;
        };
        TCheckResult CheckSign(ui64 uid, const TStringBuf sign, const TStringBuf rawString) const;

    protected:
        void Run();

    private:
        struct TKeyInfo {
            NUtils::TSshPublicKey PublicKey;
            TString Fingerprint;
        };

        struct TCache {
            using TKeys = std::vector<TKeyInfo>;
            using TByUid = std::unordered_map<ui64, TKeys>;
            using TLoginUid = std::unordered_map<TString, ui64>;
            using TUidLogin = std::unordered_map<ui64, TString>;
            TByUid ByUid;
            TLoginUid LoginToUid;
            TUidLogin UidToLogin;
        };
        using TCachePtr = std::shared_ptr<TCache>;

        static std::optional<TString> CheckSignAsIs(const TCache::TKeys& keys, const TStringBuf sign, const TStringBuf rawString);
        static std::optional<TString> CheckSignSshAgent(const TCache::TKeys& keys, const TStringBuf sign, const TStringBuf rawString);

        void RefreshViaHttp();

        struct TResp {
            TString Body;
            TDuration Time;
        };
        TResp GetPage(TKeepAliveHttpClient& client, ui32 lastEntityId);

        struct TParsePageResult {
            size_t LoginCount = 0;
            size_t KeyCount = 0;
            size_t LastId = 0;
        };
        static TParsePageResult ParsePage(rapidjson::Value& doc, TCache& cache);

        void ReadCacheFromFile();

        NUtils::TSharedState<TCache> Cache_;
        const TRuntimeContext& Runtime_;

        mutable NUnistat::TSignalDiff<> UnistatQueryErrors_ = {"internal_error.staff.query"};
        mutable NUnistat::TSignalDiff<> UnistatParsingErrors_ = {"internal_error.staff.parsing"};
        mutable NUnistat::TTimeStat UnistatResponseTime_;

        TString Token_;
    };
}
