#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NTvm {
    class TRuntimeContext;

    class TTvmCertClient {
    public:
        struct TCheckResult {
            TString Err;
        };

        explicit TTvmCertClient(const TRuntimeContext& runtime);

        TCheckResult CheckSign(const TStringBuf requestID, const TStringBuf login, const TStringBuf cert, const TStringBuf sign, const TStringBuf rawString) const;

    private:
        const TRuntimeContext& Runtime_;
        std::shared_ptr<NDbPool::TDbPool> Pool_;
    };
}
