#pragma once

#include <passport/infra/libs/cpp/unistat/name.h>
#include <passport/infra/libs/cpp/utils/atomic.h>

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/datetime/base.h>

#include <memory>
#include <shared_mutex>
#include <unordered_map>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NTvm::NTopConsumers {
    class TConsumer {
    public:
        TConsumer(const TString& name, TDuration slidingWindow);

        void Inc(TInstant now);
        ui64 Get(TInstant now);

        const TString& UnistatSignalName() const;

        struct TNode {
            NUtils::TAtomicNum<time_t> LastAccess;
            NUtils::TAtomicNum<ui64> Value;
        };
        using TNodePtr = std::unique_ptr<TNode>;

    private:
        const NUnistat::TName UnistatSignalName_;
        TStackVec<std::unique_ptr<TNode>> Data_;
    };

    using TConsumerPtr = std::shared_ptr<TConsumer>;

    struct TTopConsumersSettings {
        size_t CountToShow = 100;
        TDuration SlidingWindow = TDuration::Seconds(10);
    };

    class TTopConsumers {
    public:
        TTopConsumers(const TTopConsumersSettings& settings);

        void Add(const TString& name, TInstant now = TInstant::Now());
        void AddUnistat(NUnistat::TBuilder& builder, TInstant now = TInstant::Now()) const;

    private:
        const TTopConsumersSettings Settings_;

        mutable std::shared_mutex Mutex_;
        std::unordered_map<TString, TConsumerPtr> Storage_;
    };
}
