#pragma once

#include "output/result.h"
#include "processors/v2/check_secret.h"
#include "processors/v2/client_credentials.h"
#include "processors/v2/keys.h"
#include "processors/v2/private_keys.h"
#include "processors/v2/sshkey.h"
#include "runtime_context/runtime_context.h"

#include <passport/infra/libs/cpp/dbpool/db_pool.h>
#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/unistat/consumers.h>
#include <passport/infra/libs/cpp/unistat/handle.h>

#include <memory>

namespace NPassport::NUtils {
    class TFileLogger;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NTvm::NTopConsumers {
    class TTopConsumers;
}

namespace NPassport::NTvm {
    class TTvm {
    public:
        TTvm();
        ~TTvm();

        void Init(const NXml::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);
        void AddUnistatExtended(const TString& path, NUnistat::TBuilder& builder) const;

    private:
        void ChooseMethod(NCommon::TRequest& req);
        bool ProcessApiV2(const TStringBuf path, NCommon::TRequest& req);

        static bool CheckOnlyPost(NCommon::TRequest& req);
        static bool CheckOnlyGet(NCommon::TRequest& req);
        static void CheckDuplicatedArgs(const NCommon::TRequest& req);

        void InitLogger(const NXml::TConfig& config, const TString& path);
        void InitProcessors(const NXml::TConfig& config, const TString& path);
        static void InitExperiments(const NXml::TConfig& config, const TString& path);
        void InitMisc(const NXml::TConfig& config, const TString& path);

        void ProcessPing(NCommon::TRequest& req) const;

        void LogAccess(const NCommon::TRequest& req, TDuration duration) const;

        void Proc4Xx(const NCommon::TRequest& req);
        template <typename T>
        void ProcSignals(const NCommon::TRequest& req, T& consumers);

        static TResult GrantTypeIsUnknown(const TString& grantType);

        void HandleV2CheckSecret(NCommon::TRequest& req) const;
        void HandleV2Keys(NCommon::TRequest& req) const;
        void HandleV2PrivateKeys(NCommon::TRequest& req) const;
        void HandleV2Ticket(NCommon::TRequest& req);
        void HandleV2VerifySsh(NCommon::TRequest& req);

        TResult HandleGtClientCredentials(NCommon::TRequest& req) const;
        TResult HandleGtSshKey(NCommon::TRequest& req) const;

    private:
        std::unique_ptr<TRuntimeContext> Runtime_;
        std::unique_ptr<NUtils::TFileLogger> AccessLogger_;

        struct TUnistat {
            NUnistat::TSimpleConsumers Consumers;
            NUnistat::TSimpleConsumers ConsumersWith4Xx;
            NUnistat::TSimpleConsumers ConsumersWithOld;
            std::unique_ptr<NTopConsumers::TTopConsumers> TopConsumers;

            NUnistat::THandles Path;
            NUnistat::THandles GrantType;
        } Unistat_;

        struct TV2 {
            std::unique_ptr<NV2::TKeysProcessor> KeysProcessor;
            std::unique_ptr<NV2::TClCredProcessor> ClCredProcessor;
            std::unique_ptr<NV2::TPrivKeysProcessor> PrivKeysProcessor;
            std::unique_ptr<NV2::TSshkeyProcessor> SshkeyProcessor;
            std::unique_ptr<NV2::TCheckSecretProcessor> CheckSecretProcessor;
        } V2_;

        THashMap<TString, std::function<void(NCommon::TRequest&)>> V2Handlers_;
        THashMap<TString, std::function<TResult(NCommon::TRequest&)>> GrantTypeHandlers_;
    };
}
