#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/system/types.h>

#include <ctime>
#include <optional>
#include <vector>

namespace NPassport::NTvm {
    using TClientId = ui32;
    using TKeyId = ui32;

    class TClient {
    public:
        enum class ECheckStatus {
            Valid,
            ValidWithOldSecret,
            Invalid,
        };

        explicit TClient(TClientId id);

        void AddKeyId(TKeyId keyId);

        void SetSecret(const TString& secret);
        void SetOldSecret(const TString& secret);

        void MarkDeleted();
        bool IsDeleted() const;

        bool IsCorrect() const;

        TClientId Id() const;

        const std::vector<TKeyId>& KeysIds() const;

        const TString& Secret() const;
        const TString& OldSecret() const;
        ECheckStatus CheckSecret(const TStringBuf sign, const TStringBuf rawString) const;

        bool operator==(const TClient& other) const;

        std::optional<i64> GetAbcId() const;
        void SetAbcId(i64 id);

        void SetName(const TString& name);
        const TString& Name() const;

    private:
        TClientId Id_;

        std::vector<TKeyId> KeysIds_;

        TString Secret_;
        TString OldSecret_;

        std::optional<i64> AbcId_;
        bool IsDeleted_ = false;
        TString Name_;
    };
}
