#include "retry_settings.h"

#include <passport/infra/daemons/tvmapi/src/output/result.h>

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <library/cpp/tvmauth/client/misc/retry_settings/v1/settings.pb.h>

namespace NPassport::NTvm {
    TRetrySettingsHelper::TRetrySettingsHelper(const TConfig::TRetrySettings& settings) {
        retry_settings::v1::Settings proto;

        proto.set_exponential_backoff_min_sec(settings.ExponentialBackoffMinSec);
        proto.set_exponential_backoff_max_sec(settings.ExponentialBackoffMaxSec);
        proto.set_exponential_backoff_factor(settings.ExponentialBackoffFactor);
        proto.set_exponential_backoff_jitter(settings.ExponentialBackoffJitter);
        proto.set_max_random_sleep_default(settings.MaxRandomSleepDefaultMsec);
        proto.set_max_random_sleep_when_ok(settings.MaxRandomSleepWhenOkMsec);
        proto.set_retries_on_start(settings.RetriesOnStart);
        proto.set_retries_in_background(settings.RetriesInBackground);
        proto.set_worker_awaking_period_sec(settings.WorkerAwakingPeriodSec);
        proto.set_dsts_limit(settings.DstsLimit);
        proto.set_roles_update_period_sec(settings.RolesUpdatePeriodSec);
        proto.set_roles_warn_period_sec(settings.RolesWarnPeriodSec);

        SerializedSettings_ = NUtils::Bin2base64url(proto.SerializeAsString());
    }

    static const TString GET_RETRY_SETTINGS = "get_retry_settings";
    static const TString X_YA_RETRY_SETTINS = "X-Ya-Retry-Settings";

    void TRetrySettingsHelper::Process(const NCommon::TRequest& req, TResult& result) const {
        if (req.GetArg(GET_RETRY_SETTINGS) == "yes") {
            result.AddHeader(X_YA_RETRY_SETTINS, SerializedSettings_);
        }
    }
}
