#pragma once

#include <passport/infra/daemons/tvmapi/src/exception.h>

#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/string/split.h>

#include <util/datetime/base.h>
#include <util/generic/strbuf.h>
#include <util/generic/string.h>
#include <util/string/split.h>

#include <vector>

class TKeepAliveHttpClient;

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NTvm {
    class TResult;
    class TRuntimeContext;

    class TUtils {
    public:
        static const TString& GetRequiredArg(const NCommon::TRequest& req, const TString& arg);
        static const TString& GetRequiredUIntArg(const NCommon::TRequest& req, const TString& arg);

        template <typename Num>
        static Num GetRequiredNumArg(const NCommon::TRequest& req, const TString& arg) {
            const TString& result = GetRequiredArg(req, arg);
            Num resultNum = 0;
            if (!TryIntFromString<10>(result, resultNum)) {
                throw TIncorrectArgException::MustBeNumber(arg);
            }
            return resultNum;
        }

        static const TString& GetUIntArg(const NCommon::TRequest& req, const TString& arg);

        static void WriteJsonArrayToFile(const std::vector<TString>& v, const TString& filepath);

        static void WriteFileViaTmp(const TString& filename, TStringBuf body);

        static bool FetchWithRetries(TKeepAliveHttpClient& client,
                                     const TString& url,
                                     NUnistat::TTimeStat& hgram,
                                     ui32 tries,
                                     const TString& token,
                                     TString& out,
                                     size_t& retries,
                                     TDuration& successRespTime);

        static bool CheckTs(time_t ts, time_t allowedDiff);

        template <typename Num>
        static void CheckArgAsNumList(const TString& arg, const TString& argName) {
            std::vector<TStringBuf> splittedArg = NUtils::NormalizeListValue<TStringBuf>(arg, ",");
            for (auto& token : splittedArg) {
                Num dummy;
                if (!TryIntFromString<10>(token, dummy)) {
                    throw TIncorrectArgException::MustBeAListOfNumbers(argName);
                }
            }
        }
    };

    struct TErrorIncrementer {
        ~TErrorIncrementer() {
            if (Err) {
                ++(*Err);
            }
        }

        NUnistat::TSignalDiff<>* Err = nullptr;
    };
}
