LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    contrib/libs/openssl
    passport/infra/libs/cpp/xml
    passport/infra/libs/cpp/dbpool
    passport/infra/libs/cpp/tvm/common
    passport/infra/libs/cpp/tvm/signer
    passport/infra/daemons/tvmapi/src/proto
    library/cpp/http/simple
    library/cpp/string_utils/tskv_format
    library/cpp/tvmauth
    library/cpp/tvmauth/client/misc/retry_settings/v1
)

SRCS(
    exception.cpp
    output/result.cpp
    output/serializer.cpp
    output/status.cpp
    pregeneration/disk_cache.cpp
    pregeneration/facade.cpp
    pregeneration/generator.cpp
    pregeneration/keys.cpp
    pregeneration/storage.cpp
    processors/request_context.cpp
    processors/response_builder.cpp
    processors/v2/check_secret.cpp
    processors/v2/client_credentials.cpp
    processors/v2/keys.cpp
    processors/v2/private_keys.cpp
    processors/v2/sshkey.cpp
    runtime_context/abc_fetcher.cpp
    runtime_context/config.cpp
    runtime_context/dbfetcher.cpp
    runtime_context/experiment.cpp
    runtime_context/notify_log.cpp
    runtime_context/oauth_client.cpp
    runtime_context/public_keys_builder.cpp
    runtime_context/runtime_context.cpp
    runtime_context/staff_fetcher.cpp
    runtime_context/tvmcert_client.cpp
    runtime_context/strings.cpp
    stats/top_consumers.cpp
    tvm.cpp
    utils/client.cpp
    utils/retry_settings.cpp
    utils/utils.cpp
)

GENERATE_ENUM_SERIALIZATION(utils/client.h)

END()
