#! /bin/bash

pkgs_verify=("passport-fastcgi-tvm-config" "yandex-passport-tvm" "yandex-passport-tvmcert" "yandex-tvm-api")

mapfile -t lines
for i in "${!lines[@]}"
do
    read pkg_name pkg_ver < <(/usr/bin/dpkg-deb --show --showformat='${Package} ${Version}\n' "${lines[i]}")
    for pkg in "${pkgs_verify[@]}"; do
        if [ $pkg == $pkg_name ]; then
            debsig-verify -v ${lines[i]}
            if [ $? -ne 0 ]; then
                    echo "Error: debsig-verify for pkg ${lines[i]} failed!"
            exit 1
            fi
        fi
    done
done
