import sys

from passport.infra.daemons.tvmapi.tools.reporter.notify import run as notify
from passport.infra.daemons.tvmapi.tools.reporter.parse_error_log import run as parse_error_log
from passport.infra.daemons.tvmapi.tools.reporter.send_to_yt import run as send_to_yt


MODS = {
    'error': parse_error_log,
    'notify': notify,
    'send_to_yt': send_to_yt,
}

if __name__ == '__main__':
    known_mods = [a[0] for a in MODS.items()]

    if len(sys.argv) < 2:
        raise Exception('Choose mode: %s' % known_mods)

    mode = sys.argv[1]
    if mode not in MODS:
        raise Exception('Unknown mode %s. Known: %s' % (mode, known_mods))

    MODS[mode](sys.argv[2:])
