#include <passport/infra/daemons/tvmapi/tools/reporter/parse_access/src/parser.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <util/datetime/base.h>
#include <util/stream/output.h>
#include <util/system/info.h>

using namespace NPassport;
using namespace NPassport::NParseAccess;

// NOLINTNEXTLINE(bugprone-exception-escape)
int main(int argc, char** argv) {
    TString input;
    TString tskvOutFile;
    TString tvmConfig;

    NLastGetopt::TOpts opts;
    opts.AddHelpOption();
    opts.AddLongOption("input", "file to parse (default: yesterday)")
        .DefaultValue((TInstant::Now() - TDuration::Days(1))
                          .FormatLocalTime("/storage/logs/production-intranet/var/log/fastcgi2/tvm-access.log.%Y%m%d"))
        .StoreResult(&input);
    opts.AddLongOption("tskv-file", "tskv file with aggregates")
        .DefaultValue("./access.tskv")
        .StoreResult(&tskvOutFile);
    opts.AddLongOption("tvm-config", "file with tvm_id and tvm_secret")
        .StoreResult(&tvmConfig);

    NLastGetopt::TOptsParseResult(&opts, argc, argv);

    Cout << "Date   : " << input << Endl;

    const TTvmConfig tvm = TTvmConfig::ReadFromFile(tvmConfig);

    TInstant start = TInstant::Now();
    TParser parser(input);
    parser.Parse();
    TInstant parsingFinish = TInstant::Now();
    Cout << Endl << "Parsing took: " << (parsingFinish - start) << Endl << Endl;

    TStats stats = parser.Stats();
    stats.FetchInfo(tvm);

    stats.Print(Cout);
    {
        TFileOutput file(tskvOutFile);
        stats.PrintTskv(file);
    }

    Cout << Endl << "Postprocessing took: " << (TInstant::Now() - parsingFinish) << Endl;

    return 0;
}
