#include "parser.h"

#include <util/string/cast.h>

namespace NPassport::NParseAccess {
    TParser::TParser(const TString& input)
        : TParserBase(input)
    {
    }

    // tvm-s5.passport.yandex.net: 2020-03-24 23:59:49 22ded11d009af904 https 2a02:6b8:c03:71d:0:564:13a6:967f 0.0 200 /2/ticket dst=2000140&grant_type=client_credentials&sign=ANyJOiF-H8fKnlYRPe9vik...&src=132&ts=1585083589
    void TParser::ParseLine(TStringBuf line) {
        const char DELIM = ' ';

        TStringBuf hostname = line.NextTok(DELIM);
        TStringBuf date = line.NextTok(DELIM);
        TStringBuf time = line.NextTok(DELIM);
        TStringBuf requestId = line.NextTok(DELIM);
        TStringBuf schema = line.NextTok(DELIM);
        TStringBuf ip = line.NextTok(DELIM);
        TStringBuf responseTime = line.NextTok(DELIM);
        TStringBuf httpCode = line.NextTok(DELIM);
        TStringBuf path = line.NextTok(DELIM);
        if (path != "/") {
            path.ChopSuffix("/");
        }

        if (line.empty()) {
            return; // Log collecting artifact: hostname without log message
        }
        TStringBuf params = line;

        double resp;
        Y_ENSURE(TryFromString(responseTime, resp), "response time is not double");

        ui32 code;
        Y_ENSURE(TryIntFromString<10>(httpCode, code), "http code is not int");

        TParams args;
        if (params != "-") {
            args.reserve(8);
            while (params) {
                TStringBuf value = params.NextTok('&');
                TStringBuf key = value.NextTok('=');
                args.emplace(key, value);
            }
        }

        Stats_.Add(
            TRequest{
                .IsHttps = schema == "https",
                .Ip = ip,
                .ResponseTime = TDuration::MicroSeconds(resp * 1000),
                .HttpCode = code,
                .Path = path,
                .Params = std::move(args),
            });

        Y_UNUSED(hostname);
        Y_UNUSED(date);
        Y_UNUSED(time);
        Y_UNUSED(requestId);
    }
}
