#! /bin/sh
EMAIL=passport-stats@yandex-team.ru
#EMAIL=cerevra@yandex-team.ru

set -e

trap print_err ERR

print_err()
{
    >&2 echo "failed to complete script"
}

DATE="$1"
if [[ -z $DATE || $DATE == "-" ]]; then
    DATE=$(date -d "-1 day" +'%Y%m%d')
fi

SEND_RETRIES="$2"
if [ -z $SEND_RETRIES ]; then
    SEND_RETRIES="0"
fi

BIN_DIR=/usr/bin/yandex/tvm-reporter
TMP_DIR=/var/lib/tvm-reporter
TOKEN=$(cat /etc/yandex/tvm-reporter/yt.token)

# cleanup
rm -rf $TMP_DIR/*

# run
$BIN_DIR/parse_access \
    --tskv-file $TMP_DIR/access.tskv \
    --input "/storage/logs/production-intranet/var/log/fastcgi2/tvm-access.log.$DATE" \
    --tvm-config "/etc/yandex/tvm-reporter/tvm.conf" \
    1> $TMP_DIR/access.out \
    2> $TMP_DIR/access.err

$BIN_DIR/reporter error \
    --filename "/storage/logs/production-intranet/var/log/fastcgi2/tvm-error.log.$DATE" \
    1> $TMP_DIR/error.out \
    2> $TMP_DIR/error.err

send_to_yt(){
    $BIN_DIR/reporter "send_to_yt" \
        --tskvfile $TMP_DIR/access.tskv \
        --oauth_token $TOKEN \
        --tabledate $DATE \
        1> $TMP_DIR/send_to_yt.out \
        2> $TMP_DIR/send_to_yt.err \
    && return 0

    return 1
}

SENT_TO_YT=""
while [ $SEND_RETRIES -gt 0 ]
do
    if send_to_yt; then
        SENT_TO_YT="1"
        break
    else
        SEND_RETRIES=$(($SEND_RETRIES-1))
        SLEEP_PERIOD="600"
        echo "Failed to send report. Sleep for $SLEEP_PERIOD seconds" >> $TMP_DIR/yt.err
        sleep $SLEEP_PERIOD
    fi
done
if [ -z $SENT_TO_YT ]; then
    send_to_yt
fi

$BIN_DIR/reporter notify \
    --filename "/storage/logs/production-intranet/var/log/fastcgi2/tvm-notify.log.$DATE" \
    --oauth_token $TOKEN \
    --wet_run \
    1> $TMP_DIR/notify.out \
    2> $TMP_DIR/notify.err

# send results
cat $TMP_DIR/access.out $TMP_DIR/access.err | mail -s "TVM stats" -- $EMAIL
cat $TMP_DIR/error.out $TMP_DIR/error.err $TMP_DIR/notify.out $TMP_DIR/notify.err | mail -s "TVM warnings" -- $EMAIL
