import argparse
import datetime

import yt.wrapper


def create_client(oauth_token):
    return yt.wrapper.YtClient(proxy='hahn', token=oauth_token)


def create_table(yt, table_name):
    fields = [
        'tvm_id',
        'tvm_name',
        'abc_id',
        'grant_type',
        'total_reqs',
        'invalid_reqs',
        'avg_resp_time',
        'https',
        'all_ip',
        'args',
        'dsts',
        'abc_tags',
    ]

    attributes = {
        'schema': [{'name': f, 'type': 'string', 'required': True} for f in fields],
    }

    yt.create("table", path=table_name, attributes=attributes, force=True)


def send(tabledate, tskvfile, oauth_token):
    yt = create_client(oauth_token)

    table_name = "//home/passport/production/reports/tvmapi/" + tabledate
    create_table(yt, table_name)

    rows = [line.encode('utf-8') for line in open(tskvfile) if line != '\n']

    yt.write_table(table_name, rows, format="dsv", raw=True)


def run(argv):
    parser = argparse.ArgumentParser(description='sends report to dyn tables in YT')
    parser.add_argument('--tskvfile', type=str, help='filename with data for table')
    parser.add_argument('--oauth_token', type=str, help='oauth token to use YT')
    parser.add_argument('--tabledate', type=str, help='date - defines table name')
    args = parser.parse_args(args=argv)

    tabledate = (
        args.tabledate
        if len(args.tabledate) > 0
        else (datetime.datetime.now() - datetime.timedelta(days=1)).strftime('%Y%m%d')
    )

    send(tabledate, args.tskvfile, args.oauth_token)
