#include <passport/infra/daemons/tvmapi/src/utils/client.h>

#include <passport/infra/libs/cpp/json/reader.h>
#include <passport/infra/libs/cpp/json/writer.h>
#include <passport/infra/libs/cpp/tvm/common/decryptor.h>
#include <passport/infra/libs/cpp/utils/crypto/hash.h>
#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NTvm;

Y_UNIT_TEST_SUITE(Client) {
    const TString AES_KEY = "BtniSXCXhroPtOgXA61i5ZxSeX/solWR";
    const TString SECRET = "qwertyqwertyqwer";
    const TString OLD_SECRET = "qwertyqwerty_old";

    Y_UNIT_TEST(Secret) {
        const TString DATA = "some data";
        const TString SECRET = NUtils::Base64url2bin("CCCCCCCCCCCCCCCCCCCCCC");
        const TString OLD_SECRET = NUtils::Base64url2bin("BBBBBBBBBBBBBBBBBBBBBB");

        TClient cl(123);
        UNIT_ASSERT_VALUES_EQUAL(TClient::ECheckStatus::Invalid,
                                 cl.CheckSecret(NUtils::TCrypto::HmacSha256(SECRET, DATA), DATA));
        UNIT_ASSERT_VALUES_EQUAL(TClient::ECheckStatus::Invalid,
                                 cl.CheckSecret(NUtils::TCrypto::HmacSha256(OLD_SECRET, DATA), DATA));
        UNIT_ASSERT_VALUES_EQUAL("", cl.Secret());
        UNIT_ASSERT_VALUES_EQUAL("", cl.OldSecret());

        cl.SetSecret(SECRET);
        UNIT_ASSERT_VALUES_EQUAL(SECRET, cl.Secret());
        UNIT_ASSERT_VALUES_EQUAL("", cl.OldSecret());
        UNIT_ASSERT_VALUES_EQUAL(TClient::ECheckStatus::Valid,
                                 cl.CheckSecret(NUtils::TCrypto::HmacSha256(SECRET, DATA), DATA));
        UNIT_ASSERT_VALUES_EQUAL(TClient::ECheckStatus::Invalid,
                                 cl.CheckSecret(NUtils::TCrypto::HmacSha256(OLD_SECRET, DATA), DATA));

        cl.SetOldSecret(OLD_SECRET);
        UNIT_ASSERT_VALUES_EQUAL(SECRET, cl.Secret());
        UNIT_ASSERT_VALUES_EQUAL(OLD_SECRET, cl.OldSecret());
        UNIT_ASSERT_VALUES_EQUAL(TClient::ECheckStatus::Valid,
                                 cl.CheckSecret(NUtils::TCrypto::HmacSha256(SECRET, DATA), DATA));
        UNIT_ASSERT_VALUES_EQUAL(TClient::ECheckStatus::ValidWithOldSecret,
                                 cl.CheckSecret(NUtils::TCrypto::HmacSha256(OLD_SECRET, DATA), DATA));

        UNIT_ASSERT_EXCEPTION_CONTAINS(cl.SetSecret("qwe"),
                                       yexception,
                                       "Secret size is not correct! Id: 123");
    }

    Y_UNIT_TEST(Abc) {
        TClient cl(123);

        UNIT_ASSERT(!cl.GetAbcId());

        cl.SetAbcId(115);
        UNIT_ASSERT(cl.GetAbcId());
        UNIT_ASSERT_VALUES_EQUAL(115, *cl.GetAbcId());

        cl.SetAbcId(-1);
        UNIT_ASSERT(cl.GetAbcId());
        UNIT_ASSERT_VALUES_EQUAL(-1, *cl.GetAbcId());
    }

    Y_UNIT_TEST(KeyId) {
        TClient cl(123);

        UNIT_ASSERT(cl.KeysIds().empty());

        cl.AddKeyId(23);
        cl.AddKeyId(34);
        cl.AddKeyId(12);
        UNIT_ASSERT_VALUES_EQUAL(std::vector<TKeyId>({23, 34, 12}), cl.KeysIds());
    }

    Y_UNIT_TEST(IsCorrect) {
        TClient cl(123);

        UNIT_ASSERT(!cl.IsCorrect());
        UNIT_ASSERT(!cl.IsDeleted());

        cl.SetSecret("CCCCCCCCCCCCCCCC");
        UNIT_ASSERT(cl.IsCorrect());
        cl.AddKeyId(115);
        UNIT_ASSERT(cl.IsCorrect());

        cl.MarkDeleted();
        UNIT_ASSERT(cl.IsCorrect());
        UNIT_ASSERT(cl.IsDeleted());
    }

    Y_UNIT_TEST(Misc) {
        TClient cl(123);
        UNIT_ASSERT_VALUES_EQUAL(123, cl.Id());
        UNIT_ASSERT(TClient(123) == TClient(123));
    }
}
