#include <passport/infra/daemons/tvmapi/src/stats/top_consumers.h>

#include <passport/infra/libs/cpp/unistat/builder.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/tvmauth/unittest.h>

using namespace NPassport::NTvm::NTopConsumers;

Y_UNIT_TEST_SUITE(TopConsumers) {
    static TString Serialize(const TTopConsumers& t, const TInstant now) {
        TString res;
        NPassport::NUnistat::TBuilder builder(res);
        t.AddUnistat(builder, now);
        return res;
    }

    Y_UNIT_TEST(common) {
        TTopConsumers t(TTopConsumersSettings{
            .CountToShow = 2,
        });

        const TInstant now = TInstant::Now();
        UNIT_ASSERT_VALUES_EQUAL(R"([])",
                                 Serialize(t, now));

        t.Add("foo");
        t.Add("foo");
        UNIT_ASSERT_VALUES_EQUAL(R"([["top_consumers.foo_axxx",1]])",
                                 Serialize(t, now));

        t.Add("bar");
        UNIT_ASSERT_VALUES_EQUAL(R"([["top_consumers.foo_axxx",1],["top_consumers.bar_axxx",1]])",
                                 Serialize(t, now));

        t.Add("kek");
        t.Add("kek");
        t.Add("kek");
        UNIT_ASSERT_VALUES_EQUAL(R"([["top_consumers.kek_axxx",1],["top_consumers.foo_axxx",1]])",
                                 Serialize(t, now));
    }
}
