#include <passport/infra/daemons/tvmapi/src/utils/utils.h>

#include <passport/infra/libs/cpp/request/test/request.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport::NTvm;

Y_UNIT_TEST_SUITE(Utils) {
    Y_UNIT_TEST(Test) {
        UNIT_ASSERT(TUtils::CheckTs(time(nullptr), 60));
        UNIT_ASSERT(TUtils::CheckTs(time(nullptr) - 10, 60));
        UNIT_ASSERT(TUtils::CheckTs(time(nullptr) + 10, 60));
        UNIT_ASSERT(!TUtils::CheckTs(time(nullptr) - 100, 60));
        UNIT_ASSERT(!TUtils::CheckTs(time(nullptr) + 100, 60));
    }

    Y_UNIT_TEST(TestGetRequiredNumArg) {
        NPassport::NTest::TRequest req;
        req.Args = {{"ts", "1234"}};
        UNIT_ASSERT_EQUAL(TUtils::GetRequiredNumArg<ui32>(req, "ts"), 1234);
        req.Args = {{"ts", "1234"}};
        UNIT_ASSERT_EXCEPTION(TUtils::GetRequiredNumArg<ui8>(req, "ts"), TIncorrectArgException);
        UNIT_ASSERT_EXCEPTION(TUtils::GetRequiredNumArg<ui8>(req, "ts_other"), TMissingArgException);
        req.Args = {{"ts", "not_number"}};
        UNIT_ASSERT_EXCEPTION(TUtils::GetRequiredNumArg<ui8>(req, "ts"), TIncorrectArgException);
    }

    Y_UNIT_TEST(TestCheckArgAsNumList) {
        UNIT_ASSERT_NO_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("1234", "src"));
        UNIT_ASSERT_NO_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("1234,5678,1", "src"));
        UNIT_ASSERT_NO_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("1234, 5678, 1", "src"));
        UNIT_ASSERT_NO_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("1234,, , 5678, 1", "src"));

        UNIT_ASSERT_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("999999999999999", "src"), TIncorrectArgException);
        UNIT_ASSERT_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("1,999999999999999", "src"), TIncorrectArgException);
        UNIT_ASSERT_EXCEPTION(TUtils::CheckArgAsNumList<ui32>("1,not_num", "src"), TIncorrectArgException);
    }
}
