package task

import (
	"time"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type Runner interface {
	Run() error
}

type RegularTask struct {
	runner  Runner
	period  time.Duration
	name    string
	stopped chan bool
}

func NewRegularTask(
	runner Runner,
	period time.Duration,
	name string,
) *RegularTask {
	return &RegularTask{
		runner:  runner,
		period:  period,
		name:    name,
		stopped: make(chan bool),
	}
}

func (rt *RegularTask) Start() {
	go rt.run()
}

func (rt *RegularTask) Stop() {
	rt.stopped <- true
}

func (rt *RegularTask) run() {
	for {
		select {
		case <-rt.stopped:
			return
		case <-time.After(rt.period):
			rt.runOnce()
		}
	}
}

func (rt *RegularTask) runOnce() {
	err := rt.runner.Run()
	if err != nil {
		logger.Log().Warnf("unable to perform a task (%s): %s", rt.name, err)
	}
}
