package tvmcert

import "fmt"

type Status string

const (
	Ok               Status = "OK"
	InvalidParams    Status = "INVALID_PARAMS"
	InvalidType      Status = "INVALID_TYPE"
	InvalidCertType  Status = "INVALID_CERT_TYPE"
	InvalidCert      Status = "INVALID_CERT"
	InvalidSignature Status = "INVALID_SIGNATURE"
	InvalidCA        Status = "INVALID_CA"
)

type VerificationStatus struct {
	TvmRequestID string `json:"-"`
	Status       Status `json:"status"`
	Message      string `json:"message"`
}

func (err *VerificationStatus) Error() string {
	return fmt.Sprintf("%s - %s", err.Status, err.Message)
}
