package utils

import (
	"sync"
	"testing"

	"github.com/stretchr/testify/require"
)

// SkipYaTest Allows using yatest only tests in ide
func SkipYaTest(t *testing.T) {
	if r := recover(); r != nil {
		err, ok := r.(string)
		require.True(t, ok)
		require.Equal(t, "test context isn't initialized", err)
		t.Skip()
	}
}

type ThreadSafeError struct {
	err    error
	rwLock sync.RWMutex
}

func (e *ThreadSafeError) GetError() error {
	e.rwLock.RLock()
	defer e.rwLock.RUnlock()
	return e.err
}

func (e *ThreadSafeError) SetError(err error) {
	e.rwLock.Lock()
	defer e.rwLock.Unlock()
	e.err = err
}
