package cli

import (
	"fmt"
	"log"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmsrv"
)

var addOnlyForCheckOpts struct {
	TvmID      string
	ConfigPath string
}

var addOnlyForCheckCmd = &cobra.Command{
	Use:   "add_only_for_check",
	Short: "Add tvm-client configuration only for checking TVM-tickets",
	Long:  fmt.Sprintf("Check documentation at %s", wikilink),
	PreRunE: func(cmd *cobra.Command, args []string) error {
		if cfgfile, err := initConfigFile(addOnlyForCheckOpts.ConfigPath); err == nil {
			addOnlyForCheckOpts.ConfigPath = cfgfile
		} else {
			return err
		}

		if addOnlyForCheckOpts.TvmID == "" {
			return fmt.Errorf("src must not be empty")
		}

		return nil
	},
	RunE: func(cmd *cobra.Command, args []string) error {
		return processAddOnlyForCheck()
	},
}

func init() {
	flags := addOnlyForCheckCmd.Flags()
	flags.StringVarP(&addOnlyForCheckOpts.ConfigPath, "config", "c", "", "Configuration file")
	flags.StringVar(&addOnlyForCheckOpts.TvmID, "tvmid", "", "Your TVM_ID and Alias in id:alias format")

	RootCmd.AddCommand(addOnlyForCheckCmd)
}

func processAddOnlyForCheck() error {
	log.Println("Using configuration file: ", addOnlyForCheckOpts.ConfigPath)
	tvmcfg, err := readConfiguration(addOnlyForCheckOpts.ConfigPath)
	if err != nil {
		return fmt.Errorf("failed to read config: %s", err)
	}

	tvmid, tvmalias, err := parseSrcDst(addOnlyForCheckOpts.TvmID)
	if err != nil {
		return fmt.Errorf("failed to parse tvmid: %s", err)
	}

	removeOldConfiguration(tvmcfg, tvmid, tvmalias)

	client := tvmsrv.ClientView{}
	client.SelfTvmID = tvmid

	tvmcfg.Clients[tvmalias] = client

	if err := saveConfiguration(tvmcfg, addOnlyForCheckOpts.ConfigPath); err != nil {
		return fmt.Errorf("failed to save new config: %s", err)
	}

	log.Println("Configuration has been updated")
	return nil
}
