package cli

import (
	"fmt"
	"log"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

var env uint32
var cfgpath string
var cfgfilename string

var bbenvcmd = &cobra.Command{
	Use:   "bbenv",
	Short: "Set Blackbox Environment in configuration file",
	Long:  "Set Blackbox Environment in configuration file. Use 0 for Prod, 1 for Test, 2 for ProdYaTeam, 3 for TestYaTeam, 4 for Stress",
	PreRunE: func(cmd *cobra.Command, args []string) error {
		if env > 4 {
			return fmt.Errorf("unrecognized bbenv value %d", env)
		}

		if cfgfile, err := initConfigFile(cfgpath); err == nil {
			cfgfilename = cfgfile
		} else {
			return err
		}

		return nil
	},
	RunE: func(cmd *cobra.Command, args []string) error {
		return processAddEnv()
	},
}

func init() {
	flags := bbenvcmd.Flags()
	flags.Uint32VarP(&env, "bbenv", "e", 0, "Blackbox environment. 0 - Prod, 1 - Test, 2 - ProdYaTeam, 3 - TestYaTeam, 4 - Stress")
	flags.StringVarP(&cfgpath, "config", "c", "", "Configuration file")
	RootCmd.AddCommand(bbenvcmd)
}

func processAddEnv() error {
	log.Println("Using configuration file: ", cfgfilename)
	tvmcfg, err := readConfiguration(cfgfilename)
	if err != nil {
		return err
	}

	e := tvm.BlackboxEnv(env)
	tvmcfg.BbEnvType = &e

	if err := saveConfiguration(tvmcfg, cfgfilename); err != nil {
		return err
	}

	log.Println("Configuration has been updated")
	return nil
}
