package cli

import (
	"fmt"
	"log"

	"github.com/spf13/cobra"
)

var port uint16

var setportCommand = &cobra.Command{
	Use:   "setport",
	Short: "Set port number for http interface",
	Long:  "Set port number for http interface",
	PreRunE: func(cmd *cobra.Command, args []string) error {
		if port == 0 {
			return fmt.Errorf("http port cannot be 0")
		}

		if cfgfile, err := initConfigFile(cfgpath); err == nil {
			cfgfilename = cfgfile
		} else {
			return err
		}

		return nil
	},
	RunE: func(cmd *cobra.Command, args []string) error {
		return processSetPort()
	},
}

func init() {
	flags := setportCommand.Flags()
	flags.Uint16VarP(&port, "port", "p", 0, "port to run the service")
	flags.StringVarP(&cfgpath, "config", "c", "", "Configuration file")
	RootCmd.AddCommand(setportCommand)
}

func processSetPort() error {
	log.Println("Using configuration file: ", cfgfilename)
	tvmcfg, err := readConfiguration(cfgfilename)
	if err != nil {
		return err
	}

	tvmcfg.Port = &port
	if err := saveConfiguration(tvmcfg, cfgfilename); err != nil {
		return err
	}

	log.Println("Configuration has been updated")
	return nil
}
