package handlers

import (
	"net/http"
	"time"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmcache"
	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmcontext"
	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmtypes"
)

type StateHolder interface {
	// For handlers
	// /tvm/keys
	GetKeys() (string, time.Time, error)

	// /tvm/check{srv,usr}
	GetServiceContext() (*tvmcontext.ServiceContext, error)
	GetUserContext() (*tvmcontext.UserContext, error)

	// /tvm/tickets
	GetTicketUpdateTime() time.Time
	GetTicket(src tvm.ClientID, dst tvm.ClientID) (tvmtypes.Ticket, string, error)

	// /tvm/ping
	GetDiag() tvmcache.Diag

	// /v2/roles
	GetRoles(slug string) (*tvm.Roles, error)

	// Dummy
	Update(config *tvmtypes.OptimizedConfig, client *http.Client) error
	ForceUpdate(config *tvmtypes.OptimizedConfig, client *http.Client) error
}

const (
	birthTimeHeader = "X-Ya-TvmTool-Data-Birthtime"
)

const (
	StatusOK            = "OK"
	StatusWarning       = "WARNING"
	StatusError         = "ERROR"
	StatusCheckFailed   = "CHECK_FAILED"
	StatusInvalidTicket = "INVALID_TICKET"
	StatusNoRoles       = "NO_ROLES"
	StatusNoScopes      = "NO_SCOPES"
)

var statusToHTTPCode = map[string]int{
	StatusOK:          http.StatusOK,
	StatusWarning:     http.StatusPartialContent,
	StatusError:       http.StatusInternalServerError,
	StatusCheckFailed: http.StatusForbidden,

	// Unused. Keep them to avoid bugs in the future
	StatusInvalidTicket: http.StatusForbidden,
	StatusNoRoles:       http.StatusForbidden,
	StatusNoScopes:      http.StatusForbidden,
}
