package handlers

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmtypes"
)

type forceUpdater interface {
	ForceUpdate(config *tvmtypes.OptimizedConfig, client *http.Client) error
}

func ForceUpdateHandler(
	updater forceUpdater,
	config *tvmtypes.OptimizedConfig,
	client *http.Client,
) echo.HandlerFunc {
	return func(ctx echo.Context) error {
		err := updater.ForceUpdate(config, client)
		if err != nil {
			return &errs.Temporary{Message: err.Error()}
		}

		return ctx.String(http.StatusOK, "OK")
	}
}
