package handlers

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmtypes"
)

type MetaAlias struct {
	Alias    string       `json:"alias"`
	ClientID tvm.ClientID `json:"client_id"`
}

type MetaTenant struct {
	Self    MetaAlias   `json:"self"`
	Dsts    []MetaAlias `json:"dsts"`
	IdmSlug string      `json:"idm_slug,omitempty"`
}

type MetaResponse struct {
	BbEnv   string       `json:"bb_env"`
	Tenants []MetaTenant `json:"tenants"`
}

func GetMetaHandler(cfg *tvmtypes.OptimizedConfig) echo.HandlerFunc {
	return func(ctx echo.Context) error {
		rsp := &MetaResponse{
			BbEnv:   tvmtypes.EnvToString(cfg.GetBbEnv()),
			Tenants: make([]MetaTenant, 0),
		}

		for clientAlias, client := range cfg.GetConfig().Clients {
			tenant := MetaTenant{
				Self: MetaAlias{
					Alias:    clientAlias,
					ClientID: client.SelfTvmID,
				},
				Dsts:    make([]MetaAlias, 0),
				IdmSlug: client.IdmSlug,
			}

			for dAlias, dID := range client.Dsts {
				tenant.Dsts = append(tenant.Dsts, MetaAlias{
					dAlias,
					dID.ID,
				})
			}

			rsp.Tenants = append(rsp.Tenants, tenant)
		}

		return ctx.JSON(http.StatusOK, rsp)
	}
}
