package handlers

import (
	"net/http"
	"strconv"
	"time"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/errs"
)

type keysHolder interface {
	GetKeys() (string, time.Time, error)
}

func KeysHandler(c keysHolder) echo.HandlerFunc {
	return func(ctx echo.Context) error {
		keys, upTime, err := c.GetKeys()
		if err != nil {
			return &errs.Temporary{Message: err.Error()}
		}

		ctx.Response().Header().Set(birthTimeHeader, strconv.FormatInt(upTime.Unix(), 10))
		return ctx.String(http.StatusOK, keys)
	}
}
