package handlers

import (
	"errors"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmcache"
)

type diagHolder interface {
	GetDiag() tvmcache.Diag
}

var errUnexpected = errors.New("unexpected error: please mail to tvm-dev@yandex-team.ru")

func getError(err error) error {
	if err == nil {
		return errUnexpected
	}
	return err
}

func PingHandler(c diagHolder) echo.HandlerFunc {
	return func(ctx echo.Context) error {
		status, msg := pingImpl(c.GetDiag())

		res := ""
		if status == StatusOK {
			res = "OK"
		} else {
			res = strings.Join(msg, "\n")
		}

		return ctx.String(statusToHTTPCode[status], res)
	}
}
