package handlers

import (
	"fmt"
	"strings"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/tvmcache"
)

type pingResponseV2 struct {
	Status string `json:"status"`
	Error  string `json:"error"`
}

func PingHandlerV2(c diagHolder) echo.HandlerFunc {
	return func(ctx echo.Context) error {
		status, msg := pingImpl(c.GetDiag())

		response := pingResponseV2{
			Status: status,
			Error:  strings.Join(msg, ". "),
		}

		return ctx.JSON(statusToHTTPCode[status], response)
	}
}

func pingImpl(diag tvmcache.Diag) (string, []string) {
	if diag.Keys.Status == tvmcache.StatusError || diag.Tickets.Status == tvmcache.StatusError {
		msg := make([]string, 0, 2)
		if diag.Keys.Status == tvmcache.StatusError {
			msg = append(msg, fmt.Sprintf("keys: %s", getError(diag.Keys.LastErr)))
		}
		if diag.Tickets.Status == tvmcache.StatusError {
			msg = append(msg, fmt.Sprintf("service tickets: %s", getError(diag.Tickets.LastErr)))
		}

		return StatusError, msg
	}

	if diag.Keys.Status == tvmcache.StatusWarning ||
		diag.Tickets.Status == tvmcache.StatusWarning ||
		len(diag.TicketErrors) > 0 {
		msg := make([]string, 0, 2)

		if diag.Keys.Status == tvmcache.StatusWarning {
			msg = append(msg, fmt.Sprintf("keys: %s", getError(diag.Keys.LastErr)))
		}
		if diag.Tickets.Status == tvmcache.StatusWarning {
			msg = append(msg, fmt.Sprintf("service tickets: %s", getError(diag.Tickets.LastErr)))
		}
		for k, value := range diag.TicketErrors {
			msg = append(msg, fmt.Sprintf("Missing service ticket src=%d,dst=%d: %s", k.Src, k.Dst, value))
		}

		return StatusWarning, msg
	}

	return StatusOK, nil
}
