package httpclientmock

import (
	"net/http"
	"net/http/httputil"

	"a.yandex-team.ru/library/go/core/log"
)

type DumpRoundTripper struct {
	Log   log.Logger
	Trans *http.Transport
}

func (d DumpRoundTripper) RoundTrip(req *http.Request) (*http.Response, error) {
	data, err := httputil.DumpRequest(req, true)
	if err != nil {
		return nil, err
	}
	d.Log.Debugf("%s", data)

	rsp, err := d.Trans.RoundTrip(req)
	if err != nil {
		d.Log.Debugf("%s", err)
	} else {
		data, err := httputil.DumpResponse(rsp, true)
		if err == nil {
			d.Log.Debugf("%s", data)
		}
	}

	return rsp, err
}

func NewDumpClientWithLogger(logger log.Logger, trans *http.Transport) *http.Client {
	return &http.Client{
		Transport: DumpRoundTripper{
			Log:   logger,
			Trans: trans,
		},
	}
}
