package httpclientmock

import (
	"bytes"
	"io/ioutil"
	"net/http"
)

type TestRoundTripper struct {
	http.RoundTripper
	AnswerFunc func(req *http.Request) ([]byte, int, error)
	Headers    http.Header
}

func (t TestRoundTripper) RoundTrip(req *http.Request) (*http.Response, error) {
	h := t.Headers
	if h == nil {
		h = http.Header{}
	}

	statusCode := http.StatusOK
	var answer []byte
	var err error
	if f := t.AnswerFunc; f != nil {
		answer, statusCode, err = f(req)
	}

	return &http.Response{
		Request:       req,
		StatusCode:    statusCode,
		ContentLength: int64(len(answer)),
		Body:          ioutil.NopCloser(bytes.NewReader(answer)),
		Header:        h,
	}, err
}
