package httpclientmock

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"runtime"
	"testing"

	"github.com/labstack/echo/v4"
	"github.com/stretchr/testify/require"
)

func MakeRequest(url string, headers map[string]string) *http.Request {
	req, err := http.NewRequest("GET", "/?"+url, nil)
	if err != nil {
		panic(err)
	}
	for k, v := range headers {
		req.Header.Set(k, v)
	}
	return req
}

func whereAmI() string {
	function, file, line, _ := runtime.Caller(2)
	return fmt.Sprintf("File: %s:%d\nFunction: %s", file, line, runtime.FuncForPC(function).Name())
}

func TestCaseErr(t *testing.T, handler echo.HandlerFunc, req *http.Request, expectedError error) *http.Response {
	rec := httptest.NewRecorder()

	err := handler(echo.New().NewContext(req, rec))

	require.Error(t, err, whereAmI())
	require.IsType(t, expectedError, err, whereAmI())
	require.EqualValues(t, expectedError, err, rec.Body.String(), whereAmI())

	return rec.Result()
}

func TestCase(t *testing.T, handler echo.HandlerFunc, req *http.Request, expBody string, expCode int) *http.Response {
	rec := httptest.NewRecorder()

	err := handler(echo.New().NewContext(req, rec))

	require.NoError(t, err, whereAmI())
	require.EqualValues(t, expCode, rec.Code, rec.Body.String(), whereAmI())
	require.EqualValues(t, expBody, rec.Body.String(), whereAmI())

	return rec.Result()
}

func TestResponseStatus(t *testing.T, handler echo.HandlerFunc, req *http.Request, expCode int) (string, *http.Response) {
	rec := httptest.NewRecorder()

	err := handler(echo.New().NewContext(req, rec))

	require.NoError(t, err, whereAmI())
	require.EqualValues(t, expCode, rec.Code, rec.Body.String(), whereAmI())

	return rec.Body.String(), rec.Result()
}
