package knifeunittest

import (
	"fmt"
	"io/ioutil"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type unittestRoles map[string]*tvm.Roles

func readRolesFromDir(dir string, requiredSlugs []string) (unittestRoles, error) {
	if !strings.HasSuffix(dir, "/") {
		dir += "/"
	}

	res := make(unittestRoles)
	for _, slug := range requiredSlugs {
		filename := fmt.Sprintf("%s%s.json", dir, slug)

		body, err := ioutil.ReadFile(filename)
		if err != nil {
			return nil, xerrors.Errorf("failed to read file body '%s': %v", filename, err)
		}

		roles, err := tvm.NewRoles(body)
		if err != nil {
			return nil, xerrors.Errorf("failed to parse file '%s': %v", filename, err)
		}

		res[slug] = roles
	}

	return res, nil
}
