package middleware

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/infra/daemons/tvmtool/internal/errs"
)

func NewErrorHandleMiddlewareV1() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(ctx echo.Context) error {
			err := next(ctx)

			switch err := err.(type) {
			case nil:
				return nil

			case *echo.HTTPError:
				return ctx.String(err.Code, err.Error())

			case *errs.InvalidParam:
				return ctx.String(http.StatusBadRequest, err.Error())

			case *errs.Unauthorized:
				return ctx.String(http.StatusUnauthorized, err.Error())

			case *errs.Forbidden:
				return ctx.JSON(http.StatusForbidden, err)

			case *errs.Temporary:
				return ctx.String(http.StatusInternalServerError, err.Error())
			}

			return ctx.String(http.StatusInternalServerError, err.Error())
		}
	}
}
