package middleware

import "github.com/labstack/echo/v4"

func NewNoSniffMiddleware() echo.MiddlewareFunc {
	return func(next echo.HandlerFunc) echo.HandlerFunc {
		return func(ctx echo.Context) error {
			ctx.Response().Header().Set("X-Content-Type-Options", "nosniff")
			return next(ctx)
		}
	}
}
