package tvmapi

import (
	"crypto/hmac"
	"crypto/sha256"
	"encoding/base64"
	"errors"
	"fmt"
)

var errorSecretDecode = errors.New("invalid base64 in secret")
var errorSecretMac = errors.New("failed to sign request")

func signRequest(ts string, dst string, secret string) (string, error) {
	key, err := base64.RawURLEncoding.DecodeString(secret)
	if err != nil {
		return "", errorSecretDecode
	}
	mac := hmac.New(sha256.New, key)
	msg := fmt.Sprintf("%s|%s||", ts, dst)

	_, err = mac.Write([]byte(msg))
	if err != nil {
		return "", errorSecretMac
	}

	return base64.RawURLEncoding.EncodeToString(mac.Sum(nil)), nil
}
