package tvmcache

import (
	"sync"
	"time"
)

const (
	StatusOk      = 0
	StatusWarning = 1
	StatusError   = 2
)

type cacheState struct {
	lastError   error
	lastUpdated time.Time
	lastAttempt time.Time
	mtx         sync.RWMutex
}

type DiagState struct {
	Status     uint
	LastUpdate time.Time
	LastErr    error
}

func (c *cacheState) GetDiag(now int64, updInterval int64) DiagState {
	last, err := c.getCacheState()

	var status uint
	if now-last.Unix() < 2*updInterval {
		status = StatusOk
	} else if now-last.Unix() < 4*updInterval {
		status = StatusWarning
	} else {
		status = StatusError
	}

	return DiagState{status, last, err}
}

func (c *cacheState) IsTimeForAttempt(now int64, updInterval int64) bool {
	c.mtx.RLock()
	defer c.mtx.RUnlock()

	return now-c.lastUpdated.Unix() > updInterval && now-c.lastAttempt.Unix() > attemptMinInterval
}

func (c *cacheState) getCacheState() (time.Time, error) {
	c.mtx.RLock()
	defer c.mtx.RUnlock()

	return c.lastUpdated, c.lastError
}
