package tvmcontext

import (
	"sync"
	"time"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

var (
	mtx     sync.RWMutex
	lastHit time.Time
)

func getLastHit() time.Time {
	mtx.RLock()
	defer mtx.RUnlock()
	return lastHit
}

func isTimeToHit() bool {
	now := time.Now()
	prev := getLastHit()
	if time.Now().Before(prev.Add(10 * time.Second)) {
		return false
	}

	mtx.Lock()
	defer mtx.Unlock()

	if prev != lastHit {
		return false
	}

	lastHit = now
	return true
}

func logThrottled(err error, ticket string) {
	if !isTimeToHit() {
		return
	}

	logger.Log().Debugf("bad signature in ticket: %s. Body: %s", err, ticket)
}
