package tvmsrv

import (
	"net"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

func makeInterfacesArray(interfaceToBind string) []string {
	if interfaceToBind != "localhost" {
		return []string{interfaceToBind}
	}

	addrs, err := net.InterfaceAddrs()
	if err != nil {
		logger.Log().Warnf("failed to get list of interfaces. Try to use %s: %s", interfaceToBind, err)
		return []string{interfaceToBind}
	}
	toBind := make([]string, 0)

	for _, addr := range addrs {
		if ipnet, ok := addr.(*net.IPNet); ok && ipnet.IP.IsLoopback() {
			ip := ipnet.IP
			toBind = append(toBind, ip.String())
			logger.Log().Debugf("use interface: '%s'", ip.String())
		} else {
			logger.Log().Debugf("skip interface: is not loopback: '%s'", addr)
		}
	}

	if len(toBind) == 0 {
		logger.Log().Warnf("empty list: %s: %s", interfaceToBind, err)
		return []string{"127.0.0.1", "::1"}
	}

	return toBind
}
