//go:build !windows
// +build !windows

package tvmsrv

import (
	"net"
	"syscall"

	"golang.org/x/sys/unix"
)

func getListenConfig() net.ListenConfig {
	return net.ListenConfig{
		Control: func(network, address string, c syscall.RawConn) error {
			var opErr error
			err := c.Control(func(fd uintptr) {
				opErr = unix.SetsockoptInt(int(fd), unix.SOL_SOCKET, unix.SO_REUSEADDR, 1)
			})
			if err != nil {
				return err
			}

			return opErr
		},
	}
}
