package tvmsrv

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/passport/shared/golibs/logger"
)

type Server struct {
	HTTP *http.Server
	Name string
}

func startServers(
	interfaces *ListenedInterfaces,
	handlers *Handlers,
) ([]*Server, chan error) {
	res := make([]*Server, 0)
	errChannel := make(chan error)

	add := func(listeners []Listener, mux *echo.Echo, name string) {
		serv := &Server{
			HTTP: &http.Server{Handler: mux},
			Name: name,
		}
		res = append(res, serv)

		for idx := range listeners {
			listener := listeners[idx]
			go func() {
				logger.Log().Infof("Started the HTTP-interface (%s): %s", name, listener.printable)
				err := serv.HTTP.Serve(listener.listener)
				logger.Log().Infof("Shutting down the HTTP-interface (%s): %s", name, err)
				if err != http.ErrServerClosed {
					errChannel <- err
				}
			}()
		}
	}

	add(interfaces.Main, handlers.Main, "main")

	if len(interfaces.Ping) > 0 {
		add(interfaces.Ping, handlers.Ping, "ping")
	}

	if len(interfaces.Solomon) > 0 {
		add(interfaces.Solomon, handlers.Solomon, "solomon")
	} else {
		logger.Log().Infof(`Skip solomon interface. A "solomon" section not found in a config file`)
	}

	return res, errChannel
}
