package tvmtypes

import (
	"fmt"
	"strconv"

	"a.yandex-team.ru/library/go/yandex/tvm"
)

// TODO: make lookup with O(1)
type OptimizedConfig struct {
	cfg *Config
}

type TvmIDAlias struct {
	ID    tvm.ClientID
	Alias string
}

func NewOptimizedConfig(cfg *Config) *OptimizedConfig {
	return &OptimizedConfig{cfg: cfg}
}

func (opt *OptimizedConfig) FindClientByID(id tvm.ClientID) *Client {
	for _, v := range opt.cfg.Clients {
		if id == v.SelfTvmID {
			return &v
		}
	}

	return nil
}

func (opt *OptimizedConfig) FindClientByAlias(alias string) *Client {
	if res, ok := opt.cfg.Clients[alias]; ok {
		return &res
	}

	return nil
}

func (opt *OptimizedConfig) GetBbEnv() tvm.BlackboxEnv {
	return opt.cfg.BbEnvType
}

func (opt *OptimizedConfig) GetNumClients() int {
	return len(opt.cfg.Clients)
}

func (opt *OptimizedConfig) GetClients() []*Client {
	res := make([]*Client, len(opt.cfg.Clients))
	idx := 0
	for _, v := range opt.cfg.Clients {
		c := v
		res[idx] = &c
		idx++
	}

	return res
}

func (opt *OptimizedConfig) GetConfig() *Config {
	return opt.cfg
}

func (opt *OptimizedConfig) FindDstForClient(client *Client, dstalias string) (tvm.ClientID, string, error) {
	if dst, ok := client.Dsts[dstalias]; ok {
		return dst.ID, dstalias, nil
	}

	num, err := strconv.Atoi(dstalias)
	if err != nil {
		return 0, "", fmt.Errorf("can't find in config destination tvmid for src = %d, dstparam = %s (strconv)", client.SelfTvmID, dstalias)
	}

	for k, v := range client.Dsts {
		if v.ID == tvm.ClientID(num) {
			return v.ID, k, nil
		}
	}

	return 0, "", fmt.Errorf("can't find in config destination tvmid for src = %d, dstparam = %s (by number)", client.SelfTvmID, dstalias)
}

func (opt *OptimizedConfig) GetSolomonConfig() *SolomonConfig {
	return opt.cfg.Solomon
}
