package tvmtypes

import (
	"net/url"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type Dst struct {
	ID tvm.ClientID `json:"dst_id"`
}

// Client describes one tenant
type Client struct {
	Alias     string
	Secret    string         `json:"secret"`
	SelfTvmID tvm.ClientID   `json:"self_tvm_id"`
	Dsts      map[string]Dst `json:"dsts"`
	IdmSlug   string         `json:"roles_for_idm_slug"`
}

type SolomonConfig struct {
	BindHost     string       `json:"bind_host"`
	Port         uint16       `json:"port"`
	StageTVMID   tvm.ClientID `json:"stage_tvm_id"`
	SolomonTVMID tvm.ClientID `json:"solomon_tvm_id"`
}

type BackendsConfig struct {
	TvmURL      *url.URL     `json:"tvm_url"`
	TiroleURL   *url.URL     `json:"tirole_url"`
	TiroleTvmID tvm.ClientID `json:"tirole_tvm_id"`
}

type Config struct {
	BbEnvType      tvm.BlackboxEnv
	Backends       BackendsConfig    `json:"backends"`
	Clients        map[string]Client `json:"clients"`
	Solomon        *SolomonConfig    `json:"solomon"`
	UseSystemCerts bool
}

func (c *Config) CheckTiroleFeature(hasCacheDir bool) error {
	for selfAlias, client := range c.Clients {
		if client.IdmSlug == "" {
			continue
		}

		if !hasCacheDir {
			return xerrors.Errorf(
				"'roles_for_idm_slug'='%s' is specified in config but disk cache is not configured", client.IdmSlug)
		}

		if client.Secret == "" {
			return xerrors.Errorf(
				"'roles_for_idm_slug'='%s' is configured for client '%s' but secret is empty",
				client.IdmSlug,
				selfAlias,
			)
		}
	}

	return nil
}
