package tvmtypes

import "a.yandex-team.ru/library/go/yandex/tvm"

func EnvToString(b tvm.BlackboxEnv) string {
	switch b {
	case tvm.BlackboxProd:
		return "Prod"
	case tvm.BlackboxTest:
		return "Test"
	case tvm.BlackboxProdYateam:
		return "ProdYaTeam"
	case tvm.BlackboxTestYateam:
		return "TestYaTeam"
	case tvm.BlackboxStress:
		return "Stress"
	default:
		return "Unknown"
	}
}

type Ticket string

func IsValidEnv(env tvm.BlackboxEnv) bool {
	// env is unsigned number
	return env <= 4
}

type TicketsForOneClient map[tvm.ClientID]Ticket

type TicketsInfo struct {
	Tickets TicketsForOneClient
	Errors  map[tvm.ClientID]string
}
