#include "common.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>
#include <passport/infra/libs/cpp/xml/config.h>

#include <set>

namespace NPassport::NXunistater::NCfg {
    TString PrettifyXpath(const NXml::TConfig& config, const TString& xpath) {
        if (!config.Contains(xpath + "/@id")) {
            return xpath;
        }

        const TString id = config.AsString(xpath + "/@id");
        const TString xpathId = "[@id='" + id + "']";
        if (xpath.EndsWith(xpathId)) {
            return xpath;
        }

        TStringBuf buf = xpath;
        if (buf.ChopSuffix("]")) {
            while (buf && !NUtils::NotDigit(buf.back())) {
                buf.Chop(1);
            }
            buf.ChopSuffix("[");
        }

        return NUtils::CreateStr(buf, xpathId);
    }

    std::vector<TString> GetPrettyXpathSubkeys(const NXml::TConfig& config, const TString& xpath) {
        std::vector<TString> res = config.SubKeys(xpath);
        for (TString& s : res) {
            s = PrettifyXpath(config, s);
        }

        std::set<TString> uniqCheck;
        for (const TString& s : res) {
            Y_ENSURE(uniqCheck.insert(s).second, "id is not unique: " << s);
        }

        return res;
    }
}
