#include "list.h"

#include "parsers.h"

namespace NPassport::NXunistater::NCfgList {
    TTsvParser GetTsvParser(const NXml::TConfig& config, const TString& xpath) {
        TTsvParser res;
        res.Xpath = xpath;
        res.Signals = NCfg::GetPrettyXpathSubkeys(config, xpath + "/signals/signal");
        res.SignalTemplates = NCfg::GetPrettyXpathSubkeys(config, xpath + "/signals/signal_template");

        return res;
    }

    TTskvParser GetTskvParser(const NXml::TConfig& config, const TString& xpath) {
        TTskvParser res;
        res.Xpath = xpath;

        for (const TString& conditionSet : NCfg::GetPrettyXpathSubkeys(config, xpath + "/condition_set")) {
            TTskvParser::TConditionSet set;
            set.Xpath = conditionSet;
            set.Signals = NCfg::GetPrettyXpathSubkeys(config, conditionSet + "/signals/signal");
            set.SignalTemplates = NCfg::GetPrettyXpathSubkeys(config, conditionSet + "/signals/signal_template");

            res.Conditions.push_back(std::move(set));
        }

        return res;
    }

    std::vector<TTsvParser> ListTsvParsers(const NXml::TConfig& config, const TString& xpath) {
        std::vector<TTsvParser> res;

        for (const TString& x : NCfg::GetPrettyXpathSubkeys(config, xpath + "/parser")) {
            res.push_back(GetTsvParser(config, x));
        }

        return res;
    }

    std::vector<TTskvParser> ListTskvParsers(const NXml::TConfig& config, const TString& xpath) {
        std::vector<TTskvParser> res;

        for (const TString& x : NCfg::GetPrettyXpathSubkeys(config, xpath + "/tskv_parser")) {
            res.push_back(GetTskvParser(config, x));
        }

        return res;
    }
}
